package ru.yandex.wmconsole.service.dao;

import ru.yandex.common.util.db.LongRowMapper;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.util.List;

/**
 * User: azakharov
 * Date: 09.08.13
 * Time: 11:46
 */
public class TblCodeAgrErrorTreesDao extends AbstractDbService {

    public Long getBannedCount(HostDbHostInfo hostDbHostInfo, long nodeId, int code) throws InternalException {
        final String query =
                "SELECT banned_count FROM tbl_code_agr_error_trees WHERE host_id = ? AND node_id = ? AND code = ?";
        final List<Long> res = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(
                query, new LongRowMapper(), hostDbHostInfo.getHostDbHostId(), nodeId, code);
        if (res.isEmpty()) {
            return null;
        } else {
            return res.iterator().next();
        }
    }

    public void increaseBannedCount(HostDbHostInfo hostDbHostInfo, long nodeId, int code, long bannedCount) throws InternalException {
        final String query =
                "INSERT INTO tbl_code_agr_error_trees (host_id, node_id, code, banned_count) " +
                        "VALUES (?, ?, ?, ?) " +
                        "ON DUPLICATE KEY UPDATE banned_count = IFNULL(banned_count + ?, ?)";
        getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(
                query, hostDbHostInfo.getHostDbHostId(), nodeId, code, bannedCount, bannedCount, bannedCount);
    }

    public void insertBannedCount(HostDbHostInfo hostDbHostInfo, long nodeId, int code, long bannedCount) throws InternalException {
        final String query =
                "INSERT INTO tbl_code_agr_error_trees (host_id, node_id, code, banned_count) " +
                        "VALUES (?, ?, ?, ?) " +
                        "ON DUPLICATE KEY UPDATE banned_count = ?";
        getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(
                query, hostDbHostInfo.getHostDbHostId(), nodeId, code, bannedCount, bannedCount);
    }
}
