package ru.yandex.wmconsole.service.dao;

import ru.yandex.common.util.db.IntegerRowMapper;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.util.List;

/**
 * User: azakharov
 * Date: 05.03.14
 * Time: 12:56
 */
public class TblCustomRegionsDao extends AbstractDbService {

    public int getCustomRegionsCount(final HostDbHostInfo hostDbHostInfo) throws InternalException {
        final String query = "SELECT count(*) FROM tbl_custom_regions WHERE host_id = ? ";
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).queryForInt(
                query, hostDbHostInfo.getHostDbHostId());
    }

    private static final String SELECT_CUSTOM_REGIONS_LIST_QUERY =
            "SELECT " +
                    "    region_id " +
                    "FROM " +
                    "    tbl_custom_regions " +
                    "WHERE " +
                    "    host_id = ? ";

    public List<Integer> getCustomRegions(final HostDbHostInfo hostDbHostInfo) throws InternalException {
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(
                SELECT_CUSTOM_REGIONS_LIST_QUERY, new IntegerRowMapper(), hostDbHostInfo.getHostDbHostId());
    }
}
