package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import ru.yandex.common.util.db.IntegerRowMapper;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.sql.*;
import java.util.List;

/**
 * User: azakharov
 * Date: 21.02.14
 * Time: 16:44
 */
public class TblDicUserSettingsDao extends AbstractDbService {

    public Integer getKeyIdByName(final String name) throws InternalException {
        final String q = "SELECT key_id FROM tbl_dic_user_settings WHERE name = ? ";
        List<Integer> res = getJdbcTemplate(WMCPartition.nullPartition()).query(q, new IntegerRowMapper(), name);
        return res.isEmpty() ? null : res.iterator().next();
    }

    public Integer insertKey(final String name) throws InternalException {
        final String q = "INSERT INTO tbl_dic_user_settings (name) VALUES (?)";
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        PreparedStatementCreator statementCreator = new PreparedStatementCreator() {
            @Override
            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement statement = connection.prepareStatement(q, Statement.RETURN_GENERATED_KEYS);
                statement.setString(1, name);
                return statement;
            }
        };
        getJdbcTemplate(WMCPartition.nullPartition()).getJdbcOperations().update(statementCreator, keyHolder);
        return keyHolder.getKey().intValue();
    }
}
