package ru.yandex.wmconsole.service.dao;

import ru.yandex.wmconsole.data.DisplayNameModerationStateEnum;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * User: azakharov
 * Date: 04.03.14
 * Time: 19:48
 */
public class TblDisplayNameModerationDao extends AbstractDbService {

    public String getDisplayHostNameByHostName(String hostname) throws InternalException {
        final String query =
                "SELECT " +
                        "    display_name " +
                        "FROM " +
                        "    tbl_display_name_moderation " +
                        "WHERE " +
                        "    display_name = ? ";

        return getJdbcTemplate(WMCPartition.nullPartition()).safeQueryForString(
                query, hostname);
    }

    public DisplayNameModerationStateEnum getDisplayNameModerationStateByHostId(Long hostId) throws InternalException {

        final String query =
                "SELECT " +
                        "    state_id " +
                        "FROM " +
                        "    tbl_display_name_moderation " +
                        "WHERE " +
                        "    host_id = ? ";

        Integer value = getJdbcTemplate(WMCPartition.nullPartition()).safeQueryForInt(
                query, hostId);
        if (value != null) {
            return DisplayNameModerationStateEnum.R.fromValueOrNull(value);
        }
        return null;
    }

    public void copyDisplayNameModeration(long newHostId, String newDisplayName, long oldHostId) throws InternalException {
        final String query =
                "REPLACE INTO " +
                        "    tbl_display_name_moderation (host_id, display_name, state_id, moderator_id, performed_on) " +
                        "SELECT " +
                        "    ?, ?, state_id, moderator_id, performed_on " +
                        "FROM " +
                        "   tbl_display_name_moderation " +
                        "WHERE " +
                        "   host_id = ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, newHostId, newDisplayName, oldHostId);
    }

    public void insertChangeDisplayNameRequest(BriefHostInfo briefHostInfo, String displayName,
                                               Long userId, DisplayNameModerationStateEnum status) throws InternalException {

        final String query =
                "REPLACE INTO " +
                        "    tbl_display_name_moderation (host_id, display_name, state_id, moderator_id, performed_on) " +
                        "VALUES (?, ?, ?, ?, NOW()) ";

        getJdbcTemplate(WMCPartition.nullPartition()).update(query,
                briefHostInfo.getId(), displayName, status.getId(), userId);
    }

    public void updateDisplayNameModerationState(BriefHostInfo briefHostInfo, DisplayNameModerationStateEnum state, long userId) throws InternalException {

        final String query =
                "UPDATE " +
                        "    tbl_display_name_moderation " +
                        "SET " +
                        "    state_id = ?, moderator_id = ?, performed_on = NOW() " +
                        "WHERE host_id = ? ";

        getJdbcTemplate(WMCPartition.nullPartition()).update(query,
                state.getId(), userId, briefHostInfo.getId());
    }
}
