package ru.yandex.wmconsole.service.dao;

import org.jetbrains.annotations.Nullable;
import ru.yandex.common.util.db.IntegerRowMapper;
import ru.yandex.wmconsole.data.ErrorUrlSourceEnum;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.util.Date;
import java.util.List;

/**
 * User: azakharov
 * Date: 06.08.13
 * Time: 13:20
 */
public class TblErrorUrlsDao extends AbstractDbService {

    /**
     * insert record to tbl_error_urls
     *
     * @param hostDbHostInfo
     * @param urlId         random surrogate key
     * @param relativeUrl   error url example in the form /path/to/page
     * @param nodeId        identified of node from tbl_url_trees
     * @param addTime       add time (not visible for user)
     * @param indexedOn     last visit time
     * @param modifiedOn    last change time
     * @param state         DELETED | DUPLICATE | EMPTY | INDEXED | NEW | SEMIDUP | UNKNOWN_1 | UNKNOWN_5 | UNKNOWN_6
     * @param size
     * @param code
     * @param hasIntLinks
     * @param hasExtLinks
     * @param isFiltered
     * @param sitemapId
     */
    public void insertErrorUrl(
            HostDbHostInfo hostDbHostInfo,
            long urlId,
            String relativeUrl,
            long nodeId,
            Date addTime,
            Date indexedOn,
            Date modifiedOn,
            int state,
            long size,
            int code,
            boolean hasIntLinks,
            boolean hasExtLinks,
            boolean isFiltered,
            @Nullable Long sitemapId,
            ErrorUrlSourceEnum source) throws InternalException {

        final String query = "INSERT INTO tbl_error_urls (" +
                "url_id, host_id, url, node_id, add_time, indexed_on, modified_on, " +
                "state, size, code, has_int_links, has_ext_links, is_filtered, sitemap_id, source) " +
                " VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(query,
                urlId, hostDbHostInfo.getHostDbHostId(), relativeUrl, nodeId, addTime, indexedOn, modifiedOn, state, size, code,
                hasIntLinks, hasExtLinks, isFiltered, sitemapId, source.getId());
    }

    public int removeErrorUrl(HostDbHostInfo hostDbHostInfo, String url) throws InternalException {
        final String query = "DELETE FROM tbl_error_urls WHERE host_id = ? AND url = ?";
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(query, hostDbHostInfo.getHostDbHostId(), url);
    }

    public int removeErrorUrls(HostDbHostInfo hostDbHostInfo, ErrorUrlSourceEnum source) throws InternalException {
        final String query = "DELETE FROM tbl_error_urls WHERE host_id = ? AND source = ? ";
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(query, hostDbHostInfo.getHostDbHostId(), source.getId());
    }

    public int updateErrorUrl(HostDbHostInfo hostDbHostInfo, String url, int httpCode) throws InternalException {
        final String query = "UPDATE tbl_error_urls SET code = ? WHERE host_id = ? AND url = ?";
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(query, httpCode, hostDbHostInfo.getHostDbHostId(), url);
    }

    public Integer getErrorUrlHttpCode(HostDbHostInfo hostDbHostInfo, String url) throws InternalException {
        final String query = "SELECT code FROM tbl_error_urls WHERE host_id = ? AND url = ?";
        List<Integer> res = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(
                query, new IntegerRowMapper(), hostDbHostInfo.getHostDbHostId(), url);
        return res.isEmpty() ? null : res.iterator().next();
    }
}
