package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.info.HostUpdatesInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.service.LinkType;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;
import ru.yandex.wmtools.common.util.SqlUtil;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

/**
 * User: azakharov
 * Date: 09.01.14
 * Time: 13:22
 */
public class TblHostUpdatesDao extends AbstractDbService {

    public HostUpdatesInfo getHostUpdatesInfo(final HostDbHostInfo hostDbHostInfo, final LinkType linkType) throws InternalException {
        final String query =
                "SELECT      offline_%s_updated AS " + HostUpdatesInfoMapper.FIELD_OFFLINE_LINKS_UPDATED + ", " +
                        "    offline_%s_size AS " + HostUpdatesInfoMapper.FIELD_OFFLINE_LINKS_SIZE + " " +
                        "FROM tbl_host_updates WHERE host_id = ?";
        return getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).safeQueryForObject(
                String.format(query, linkType.getName(), linkType.getName()),
                new HostUpdatesInfoMapper(), hostDbHostInfo.getHostDbHostId());
    }

    public void deleteOldOfflineLinks(final int dbNumber) throws InternalException {
        final String query = "UPDATE tbl_host_updates SET offline_link_updated = NULL, offline_link_size = NULL "+
                             "WHERE offline_link_updated IS NOT NULL AND offline_link_updated < DATE_SUB(NOW(), INTERVAL 30 DAY)";
        getJdbcTemplate(new WMCPartition(dbNumber)).update(query);
    }

    private static class HostUpdatesInfoMapper implements ParameterizedRowMapper<HostUpdatesInfo> {
        public static final String FIELD_OFFLINE_LINKS_UPDATED = "offline_links_updated";
        public static final String FIELD_OFFLINE_LINKS_SIZE = "offline_links_size";

        @Override
        public HostUpdatesInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            Date fileUpdated = SqlUtil.safeGetTimestamp(rs, FIELD_OFFLINE_LINKS_UPDATED);
            BigDecimal size = rs.getBigDecimal(FIELD_OFFLINE_LINKS_SIZE);
            return new HostUpdatesInfo(fileUpdated, (size == null) ? null : size.longValue());
        }
    }
}
