package ru.yandex.wmconsole.service.dao;

import org.joda.time.DateTime;
import ru.yandex.common.util.db.LongRowMapper;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.util.Date;
import java.util.List;

/**
 * User: azakharov
 * Date: 21.06.13
 * Time: 16:26
 */
public class TblHostmonMonitoringDao extends AbstractDbService {

    /**
     * Сохранить число хостов за сутки
     *
     * @param date      обязательно полночь. Если указанная дата не полночь, бросает исключение IllegalArgumentException
     * @param count     количество хостов, для которых есть данные по хостомону за сутки с <code>date</code> до следующей полночи
     * @throws InternalException
     */
    public void saveHostsCount(final Date date, final long count) throws InternalException {
        DateTime arg = new DateTime(date.getTime());
        if (arg.isAfter(arg.toDateMidnight())) {
            throw new IllegalArgumentException("parameter date is not midnight");
        }
        final String SAVE_HOSTS_COUNT_QUERY =
                "INSERT INTO " +
                        "tbl_hostmon_monitoring " +
                        "       (day, host_count) " +
                        "VALUES " +
                        "       (?, ?) ";
        getJdbcTemplate(WMCPartition.nullPartition()).update(SAVE_HOSTS_COUNT_QUERY, date, count);
    }

    public Long getHostsCount(final Date date) throws InternalException {
        DateTime arg = new DateTime(date.getTime());
        if (arg.isAfter(arg.toDateMidnight())) {
            throw new IllegalArgumentException("parameter date is not midnight");
        }
        final String GET_HOSTS_COUNT_QUERY =
                "SELECT " +
                        "   host_count " +
                        "FROM " +
                        "   tbl_hostmon_monitoring " +
                        "WHERE " +
                        "   day = ? ";
        List<Long> l = getJdbcTemplate(WMCPartition.nullPartition()).query(GET_HOSTS_COUNT_QUERY, new LongRowMapper(), date);
        return l.isEmpty()? null : l.iterator().next();
    }
}
