package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * User: azakharov
 * Date: 11.03.14
 * Time: 14:55
 */
public class TblMainMirrorNotificationPairDao extends AbstractDbService {

    public void savePair(long mirrorGroupsId, String hostName, String newMainMirror) throws InternalException {
        final String q = "INSERT INTO tbl_main_mirror_notification_pair " +
                         "  (mirror_groups_id, host_name, new_main_mirror) VALUES (?, ?, ?)";
        getJdbcTemplate(WMCPartition.nullPartition()).update(q, mirrorGroupsId, hostName, newMainMirror);
    }

    public List<Pair<String, String>> getMirrorGroups(long mirrorGroupsId) throws InternalException {
        final String q = "SELECT host_name, new_main_mirror FROM tbl_main_mirror_notification_pair WHERE mirror_groups_id = ? ";
        final ParameterizedRowMapper<Pair<String, String>> m = new ParameterizedRowMapper<Pair<String, String>>() {
            @Override
            public Pair<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new Pair<>(rs.getString("host_name"), rs.getString("new_main_mirror"));
            }
        };
        return getJdbcTemplate(WMCPartition.nullPartition()).query(q, m, mirrorGroupsId);
    }
}
