package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import ru.yandex.wmconsole.data.info.notification.MainMirrorNotificationInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

import java.sql.*;
import java.util.Date;

/**
 * User: azakharov
 * Date: 14.03.14
 * Time: 12:23
 */
public class TblNotificationMirrorChangedDao extends AbstractDbService {

    public long addMainMirrorChangeNotification(final String oldHost, final String newHost, final Date date)
            throws InternalException {

        final String INSERT_MAIN_MIRROR_CHANGE_NOTIFICATION_QUERY =
                "INSERT INTO " +
                        "   tbl_notification_mirrorchanged (old_host, new_host, receive_time) " +
                        "VALUES" +
                        "   (?, ?, ?)";
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        PreparedStatementCreator psc = new PreparedStatementCreator() {
            @Override
            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(INSERT_MAIN_MIRROR_CHANGE_NOTIFICATION_QUERY,
                        Statement.RETURN_GENERATED_KEYS);
                ps.setString(1, oldHost);
                ps.setString(2, newHost);
                ps.setTimestamp(3, new Timestamp(date.getTime()));
                return ps;
            }
        };

        getJdbcTemplate(WMCPartition.nullPartition()).getJdbcOperations().update(psc, generatedKeyHolder);
        return generatedKeyHolder.getKey().longValue();
    }

    public MainMirrorNotificationInfo getMainMirrorChangeNotification(Long issueId) throws InternalException {

        final String SELECT_MAIN_MIRROR_CHANGE_NOTIFICATION_QUERY =
                "SELECT " +
                        "   mirrorchanged_id, " +
                        "   old_host, " +
                        "   new_host, " +
                        "   receive_time " +
                        "FROM " +
                        "   tbl_notification_mirrorchanged " +
                        "WHERE " +
                        "   mirrorchanged_id = ?";
        return getJdbcTemplate(WMCPartition.nullPartition()).safeQueryForObject(
                SELECT_MAIN_MIRROR_CHANGE_NOTIFICATION_QUERY, MAIN_MIRROR_USER_NOTIFICATION_MAPPER, issueId);
    }

    private static final ParameterizedRowMapper<MainMirrorNotificationInfo> MAIN_MIRROR_USER_NOTIFICATION_MAPPER =
            new ParameterizedRowMapper<MainMirrorNotificationInfo>() {
                private static final String FIELD_ID = "mirrorchanged_id";
                private static final String FIELD_OLD_HOST = "old_host";
                private static final String FIELD_NEW_HOST = "new_host";
                private static final String FIELD_RECEIVE_TIME = "receive_time";

                @Override
                public MainMirrorNotificationInfo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
                    Long id = resultSet.getLong(FIELD_ID);
                    String oldHost = resultSet.getString(FIELD_OLD_HOST);
                    String newHost = resultSet.getString(FIELD_NEW_HOST);
                    Date receiveTime = resultSet.getDate(FIELD_RECEIVE_TIME);
                    return new MainMirrorNotificationInfo(0, id, oldHost, newHost, receiveTime);
                }
            };

}
