package ru.yandex.wmconsole.service.dao;

import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * User: azakharov
 * Date: 14.10.13
 * Time: 18:48
 */
public class TblPeriodicCounterDao extends AbstractDbService {
    public long getIndexHistoryTaskHostId() throws InternalException {
        String query1 = "SELECT index_history_min_host_id FROM tbl_periodic_counter";
        return getJdbcTemplate(WMCPartition.nullPartition()).queryForLong(query1);
    }

    public void updateIndexHistoryTaskHostId(long hostId) throws InternalException {
        String query2 = "UPDATE tbl_periodic_counter SET index_history_min_host_id = ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query2, hostId);
    }

    public int getCurrentHostNum() throws InternalException {
        final String query = "SELECT current_host_num FROM tbl_periodic_counter";
        return getJdbcTemplate(WMCPartition.nullPartition()).queryForInt(query);
    }

    public int updateCurrentHostNum(int num) throws InternalException {
        final String query = "UPDATE tbl_periodic_counter SET current_host_num = ?";
        return getJdbcTemplate(WMCPartition.nullPartition()).update(query, num);
    }
}
