package ru.yandex.wmconsole.service.dao;

import ru.yandex.wmconsole.data.HostRegionChangeRequestStateEnum;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * User: azakharov
 * Date: 05.03.14
 * Time: 13:09
 */
public class TblRegionModerationDao extends AbstractDbService {

    public void updateRegionModerationHostId(long oldHostId, long newHostId) throws InternalException {
        final String query = "UPDATE tbl_region_moderation SET host_id = ? WHERE host_id = ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, newHostId, oldHostId);
    }

    public void deleteRegionModeration(long hostId) throws InternalException {
        final String query = "DELETE FROM tbl_region_moderation WHERE host_id = ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, hostId);
    }

    public void insertRegionModerationHistory(final long userId, final BriefHostInfo hostInfo, HostRegionChangeRequestStateEnum state, String url, int regionId, Long autoRegionId) throws InternalException {
        final String query =
                "INSERT INTO " +
                        "    tbl_region_moderation (moderator_id, host_id, hostname, performed_on, state_id, region_id, url, auto_region_id) " +
                        "VALUES " +
                        "    (?, ?, ?, NOW(), ?, ?, ?, ?)";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query,
                userId,
                hostInfo.getId(),
                hostInfo.getName(),
                state.getValue(),
                regionId,
                url,
                autoRegionId);
    }
}
