package ru.yandex.wmconsole.service.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.common.util.collections.Cu;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.common.util.db.LongRowMapper;
import ru.yandex.webmaster.common.urltree.YandexSearchShard;
import ru.yandex.wmconsole.data.info.HostDbHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;
import ru.yandex.wmtools.common.util.SqlUtil;

/**
 * User: azakharov
 * Date: 09.08.13
 * Time: 13:53
 */
public class TblUrlTreesDao extends AbstractDbService {

    public void increaseBannedCount(final HostDbHostInfo hostDbHostInfo, final Long nodeId, final Long bannedCount) throws InternalException {
        final String query = "UPDATE tbl_url_trees SET banned_count = IFNULL(banned_count + ?, ?) WHERE host_id = ? AND id = ?";
        getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(query, bannedCount, bannedCount, hostDbHostInfo.getHostDbHostId(), nodeId);
    }

    public void updateBannedCount(final HostDbHostInfo hostDbHostInfo, final Long nodeId, final Long bannedCount) throws InternalException {
        final String query = "UPDATE tbl_url_trees SET banned_count = ? WHERE host_id = ? AND id = ?";
        getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).update(query, bannedCount, hostDbHostInfo.getHostDbHostId(), nodeId);
    }

    public Long getIndexCount(final HostDbHostInfo hostDbHostInfo, final Long nodeId, final YandexSearchShard shard) throws InternalException {
        final String query = "SELECT index_count FROM tbl_url_trees WHERE host_id = ? AND id = ? AND shard_id = ?";
        List<Long> result = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(query, new LongRowMapper(), hostDbHostInfo.getHostDbHostId(), nodeId, shard.value());
        return result.isEmpty() ? null : result.iterator().next();
    }

    public Long getIndexCount(final HostDbHostInfo hostDbHostInfo, final YandexSearchShard shard) throws InternalException {
        String q = "SELECT index_count FROM tbl_url_trees WHERE parent_id IS NULL AND host_id = ? AND shard_id = ?";
        List<Long> result = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(q, new LongRowMapper(), hostDbHostInfo.getHostDbHostId(), shard.value());
        return result.isEmpty() ? null : result.iterator().next();
    }

    public Long getUrls(final HostDbHostInfo hostDbHostInfo, final Long nodeId) throws InternalException {
        final String query = "SELECT urls FROM tbl_url_trees WHERE host_id = ? AND id = ?";
        List<Long> result = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(query, new LongRowMapper(), hostDbHostInfo.getHostDbHostId(), nodeId);
        return result.isEmpty() ? null : result.iterator().next();
    }

    /**
     * Returns shard id with maximum index count value for root of the site structure
     *
     * @param hostDbHostInfo        host db info
     * @return                      shard enum value
     * @throws InternalException    on database error
     */
    public @NotNull YandexSearchShard getOptimumShardId(final HostDbHostInfo hostDbHostInfo) throws InternalException {
        // TODO: WMC-1139 force RU shard
        return YandexSearchShard.RU;

//        final String query =
//                "SELECT shard_id FROM tbl_url_trees " +
//                "WHERE host_id = ? AND parent_id IS NULL ORDER BY index_count DESC, shard_id ASC LIMIT 1";
//        List<Integer> result = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(query, new IntegerRowMapper(), hostDbHostInfo.getHostDbHostId());
//        if (result.isEmpty()) {
//            return YandexSearchShard.RU;
//        }
//        YandexSearchShard shard = YandexSearchShard.R.fromValueOrNull(Cu.first(result));
//        return shard != null ? shard : YandexSearchShard.RU;
    }

    /**
     * Returns shard id with maximum index count value for root of the site structure
     *
     * @param hostDbHostInfo        host db info
     * @return                      shard enum value and pages in index for the shard
     * @throws InternalException    on database error
     */
    public @NotNull
    Pair<YandexSearchShard, Long> getOptimumShardIdAndIndexCount(final HostDbHostInfo hostDbHostInfo) throws InternalException {
        // TODO: WMC-1139 force RU shard

//        final String query =
//                "SELECT shard_id, index_count FROM tbl_url_trees " +
//                        "WHERE host_id = ? AND parent_id IS NULL ORDER BY index_count DESC, shard_id ASC LIMIT 1";
        final String query =
                "SELECT shard_id, index_count FROM tbl_url_trees " +
                        "WHERE host_id = ? AND parent_id IS NULL and shard_id = ?";

        final ParameterizedRowMapper<Pair<YandexSearchShard, Long>> m = new ParameterizedRowMapper<Pair<YandexSearchShard, Long>>() {
            @Override
            public Pair<YandexSearchShard, Long> mapRow(ResultSet rs, int rowNum) throws SQLException {
                YandexSearchShard shard = YandexSearchShard.R.fromValueOrNull(rs.getInt("shard_id"));
                if (shard == null) {
                    shard = YandexSearchShard.RU;
                }
                return new Pair<>(shard, SqlUtil.getLongNullable(rs, "index_count"));
            }
        };

        List<Pair<YandexSearchShard,Long>> result = getJdbcTemplate(new WMCPartition(hostDbHostInfo, null)).query(query, m,
                hostDbHostInfo.getHostDbHostId(), YandexSearchShard.RU.value());

        if (result.isEmpty()) {
            return new Pair<>(YandexSearchShard.RU, null);
        }
        return Cu.first(result);
    }
}
