package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;
import ru.yandex.wmtools.common.util.SqlUtil;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * User: azakharov
 * Date: 21.02.14
 * Time: 16:45
 */
public class TblUserSerttingsMetaDao extends AbstractDbService {

    public Map<String, String> getUserSettings(long userId, List<String> keys) throws InternalException {
        final String q = String.format(
                    "SELECT d.name, s.value " +
                         "FROM tbl_user_settings s JOIN tbl_dic_user_settings d ON s.key_id = d.key_id " +
                         "WHERE s.user_id = ? AND d.name IN (%s)",
                        SqlUtil.getCommaSeparatedList(keys, listParameterizer));
        final Map<String,String> result = new HashMap<>();
        getJdbcTemplate(WMCPartition.nullPartition()).
                query(q, new ParameterizedRowMapper<Object>() {
                    @Override
                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        result.put(rs.getString("name"), rs.getString("value"));
                        return null;
                    }
                }, userId);
        return result;
    }

    public Map<String, String> getUserSettings(long userId) throws InternalException {
        final String q = "SELECT d.name, s.value " +
                         "FROM tbl_user_settings s JOIN tbl_dic_user_settings d ON s.key_id = d.key_id " +
                         "WHERE s.user_id = ?";
        final Map<String,String> result = new HashMap<>();
        getJdbcTemplate(WMCPartition.nullPartition()).
                query(q, new ParameterizedRowMapper<Object>() {
                    @Override
                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        result.put(rs.getString("name"), rs.getString("value"));
                        return null;
                    }
                }, userId);
        return result;
    }

    public void insertUserSettings(long userId, int key, String value) throws InternalException {
        final String q = "INSERT INTO tbl_user_settings (user_id, key_id, value) values (?, ?, ?)";
        getJdbcTemplate(WMCPartition.nullPartition()).update(q, userId, key, value);
    }

    private static final SqlUtil.ListParameterizer<String> listParameterizer = new SqlUtil.ListParameterizer<String>() {
        @Override
        public String getParameter(int i, String obj) {
            return obj.toString();
        }

        @Override
        public int getParamNumber() {
            return 1;
        }

        @Override
        public boolean isQuotesNeeded(int i) {
            return true;
        }
    };
}
