package ru.yandex.wmconsole.service.dao;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import ru.yandex.wmconsole.data.info.UsersHostsCacheInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;
import ru.yandex.wmtools.common.util.SqlUtil;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

/**
 * User: azakharov
 * Date: 24.07.13
 * Time: 17:13
 */
public class TblUsersHostsCacheDao extends AbstractDbService {

    public UsersHostsCacheInfo getUsersHostsCache(long userId, long hostId) throws InternalException {
        final String query =
                "SELECT " +
                        "errors_count, " +
                        "errors_count_trend, " +
                        "count_updated_on " +
                "FROM " +
                        "tbl_users_hosts_cache " +
                "WHERE " +
                        "   user_id = ? " +
                        "AND " +
                        "   host_id = ?";
        List<UsersHostsCacheInfo> res =
                getJdbcTemplate(WMCPartition.nullPartition()).query(query, mapper, userId, hostId);
        return res.isEmpty() ? null : res.iterator().next();
    }

    public void updateUsersHostsCache(long userId, long hostId, Long errorsCount, Long errorsCountTrend, Date countUpdatedOn) throws InternalException {
        final String query =
                "REPLACE INTO " +
                        "    tbl_users_hosts_cache (host_id, user_id, errors_count, errors_count_trend, count_updated_on) " +
                        "VALUES " +
                        "    (?, ?, ?, ?, ?) ";

        getJdbcTemplate(new WMCPartition(null, userId)).update(
                query, hostId, userId, errorsCount, errorsCountTrend, countUpdatedOn);
    }

    private final static ParameterizedRowMapper<UsersHostsCacheInfo> mapper = new ParameterizedRowMapper<UsersHostsCacheInfo>() {
        @Override
        public UsersHostsCacheInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new UsersHostsCacheInfo(
                    SqlUtil.getLongNullable(rs, "errors_count"),
                    SqlUtil.getLongNullable(rs, "errors_count_trend"),
                    SqlUtil.safeGetTimestamp(rs, "count_updated_on"));
        }
    };
}
