package ru.yandex.wmconsole.service.dao;

import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * User: azakharov
 * Date: 05.03.14
 * Time: 16:22
 */
public class TblUsersHostsRegionsDao extends AbstractDbService {

    public void copyUsersHostsRegions(long oldHostId, long newHostId) throws InternalException {
        final String query =
                "INSERT IGNORE INTO " +
                        "   tbl_user_hosts_regions (host_id, region_id, state_id, user_id, update_day, check_day, moderator_id, confirmed, url, comment) " +
                        "SELECT " +
                        "   ?, region_id, state_id, user_id, update_day, check_day, moderator_id, confirmed, url, comment " +
                        "FROM " +
                        "   tbl_user_hosts_regions " +
                        "WHERE " +
                        "   host_id = ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, newHostId, oldHostId);
    }
}
