package ru.yandex.wmconsole.service.dao;

import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * User: azakharov
 * Date: 05.03.14
 * Time: 14:00
 */
public class TblVerifiedHostsRegionsDao extends AbstractDbService {

    public void copyVerifiedHostsRegions(final long oldHostId, final long newHostId) throws InternalException {
        final String query =
                "INSERT IGNORE INTO " +
                        "   tbl_verified_hosts_regions (host_id, region_id) " +
                        "SELECT " +
                        "   ?, region_id " +
                        "FROM " +
                        "   tbl_verified_hosts_regions " +
                        "WHERE " +
                        "   host_id = ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(
                query, newHostId, oldHostId);
    }

    public void deleteVerifiedHostsRegions(final BriefHostInfo hostInfo) throws InternalException {
        final String query = "DELETE FROM tbl_verified_hosts_regions WHERE host_id = ? ";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, hostInfo.getId());
    }

    public void insertVerifiedHostsRegions(final BriefHostInfo hostInfo, int region) throws InternalException {
        final String query =
                "INSERT INTO " +
                        "    tbl_verified_hosts_regions (host_id, region_id) " +
                        "VALUES " +
                        "    (?, ?) " +
                        "ON DUPLICATE KEY UPDATE " +
                        "    region_id = ? ";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, hostInfo.getId(), region, region);
    }
}
