package ru.yandex.wmconsole.service.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.webmaster.common.xml.limits.LimitDelegationInfo;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * User: azakharov
 * Date: 13.09.13
 * Time: 16:44
 */
public class TblXmlLimitDelegationsDao extends AbstractDbService {

    private static final String FIELD_HOST_ID = "host_id";
    private static final String FIELD_MAIN_USER = "main_user";
    private static final String FIELD_FROM_USER_ID = "from_user_id";
    private static final String FIELD_TO_USER_ID = "to_user_id";
    private static final String FIELD_DELEGATION_DATE = "delegation_date";

    public LimitDelegationInfo getDelegationForHost(long hostId) throws InternalException {
        final String query =
                "SELECT " +
                        "   host_id AS " + FIELD_HOST_ID + ", " +
                        "   main_user_id AS " + FIELD_MAIN_USER + ", " +
                        "   from_user_id AS " + FIELD_FROM_USER_ID + ", " +
                        "   to_user_id AS " + FIELD_TO_USER_ID + ", " +
                        "   delegation_date AS " + FIELD_DELEGATION_DATE + " " +
                        "FROM " +
                        "   tbl_xmllimit_delegations " +
                        "WHERE " +
                        "   host_id = ? ";

        return getJdbcTemplate(WMCPartition.nullPartition()).safeQueryForObject(query, limitDelegationMapper, hostId);
    }

    public void insertLimitDelegation(long hostId, long mainUserId, long oldUserId, long newUserId) throws InternalException {
        final String query =
                "REPLACE INTO " +
                "   tbl_xmllimit_delegations " +
                "   (host_id, main_user_id, from_user_id, to_user_id, delegation_date) " +
                "VALUES " +
                "   (?, ?, ?, ?, NOW()) ";
        // insert delegation
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, hostId, mainUserId, oldUserId, newUserId);
    }

    public void deleteDelegation(long hostId) throws InternalException {
        final String query =
                "DELETE FROM tbl_xmllimit_delegations WHERE host_id = ?";
        getJdbcTemplate(WMCPartition.nullPartition()).update(query, hostId);
    }

    public void safeDelegateLimits(BriefHostInfo host, long toUserId) throws InternalException {
        String q =
                "INSERT IGNORE INTO tbl_xmllimit_delegations " +
                "   (host_id, main_user_id, from_user_id, to_user_id, delegation_date) " +
                " VALUES " +
                "   (?, ?, ?, ?, NOW()) "
                ;
        getJdbcTemplate(WMCPartition.nullPartition()).update(q, host.getId(), toUserId, toUserId, toUserId);
    }

    private static final ParameterizedRowMapper<LimitDelegationInfo> limitDelegationMapper = new ParameterizedRowMapper<LimitDelegationInfo>() {
        @Override
        public LimitDelegationInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            long hostId = rs.getLong(FIELD_HOST_ID);
            long mainUserId = rs.getLong(FIELD_MAIN_USER);
            long fromUserId = rs.getLong(FIELD_FROM_USER_ID);
            long toUserId = rs.getLong(FIELD_TO_USER_ID);
            Date delegationDate = rs.getDate(FIELD_DELEGATION_DATE);
            return new LimitDelegationInfo(hostId, null, mainUserId, null, fromUserId, null, toUserId, null, delegationDate);
        }
    };
}
