package ru.yandex.wmconsole.service.error;

import ru.yandex.wmtools.common.error.IUserProblem;

/**
 * User problems specific to Webmaster project.
 *
 * @author ailyin
 */
public enum WMCUserProblem implements IUserProblem {
    // former WMCServantletErrors
    // display name
    IDN_ARE_NOT_SUPPORTED,
    NOT_MATCHING_DISPLAY_NAME,
    SAME_DISPLAY_NAME,
    INVALID_DISPLAY_NAME,

    HOST_NOT_OWNED_BY_USER,
    HOST_NOT_VERIFIED_BY_USER,
    EMAIL_NOT_VERIFIED,
    EMAIL_NOT_VALID,
    MESSAGE_NOT_OWNED_BY_USER,

    // robots.txt
    TOO_MANY_URLS,
    NO_HOST_OR_ROBOTSTXT,

    // add host errors
    PATH_NOT_EMPTY,

    // offline links
    OFFLINE_OPTION_DISABLED,
    OFFLINE_FILE_NOT_READY,

    // speller
    CANT_GET_HTML,

    // host regions
    TOO_SMALL_TCY,
    REGION_IS_NOT_ALLOWED_TO_SET,
    HOST_NOT_ACCESSIBLE,
    REGION_SET_IN_CATALOG,

    // former WMCServiceErrors
    HOST_NOT_AVAILABLE,
    NO_DATA_FOR_HOST,
    HOST_ALREADY_ADDED,
    HOST_IS_MIRROR,
    HOST_IS_MIRROR2,
    HOST_REFUSED_BY_ADDURL,
    ILLEGAL_PORT_NUMBER,

    // sitemap errors
    SITEMAP_NOT_OWNED,
    SITEMAP_ALREADY_EXISTS,
    SITEMAP_IS_NOT_AVAILABLE,
    SITEMAP_ACCESS_ERROR,
    EMPTY_SITEMAP,
    SITEMAP_IS_HOMEPAGE,

    USERS_HOSTS_COUNT_LIMIT_EXCEEDED,

    ROBOTS_TXT_ACCESS_ERROR,
    EMPTY_ROBOTS_TXT,

    //addurl
    HOST_IS_MIRROR_MAIN_MIRROR_IS_INDEXED,
    HOST_IS_MIRROR_MAIN_MIRROR_IS_NOT_INDEXED,
    URL_IS_ALREADY_INDEXED,
    RESPONSE_TIME_LIMIT_WAS_EXCEEDED,
    SERVER_IS_NOT_AVAILABLE,
    URL_IS_DISALLOWED_IN_ROBOTS_TXT,
    ADD_URL_RATE_LIMIT,

    //delurl
    URL_IS_NOT_INDEXED,
    URL_IS_FAKE,
    NO_REASONS_TO_DELETE_URL,

    //messages
    NO_SUCH_MESSAGE,
    WRONG_MESSAGE_TYPE,
    MESSAGE_IS_READ_ONLY,

    // speller
    HTML_PARSE_ERROR,

    //http responce checker
    URL_CONNECTION_PROBLEM,

    //host info widget
    NO_VERIFIED_HOSTS,

    PUBLIC_REINDEXURL_HOST_LIMIT_EXCEEDED,

    // delegations
    NO_SUCH_DELEGATION_FOUND,
    HOST_ALREADY_VERIFIED,
    DELEGATION_FORBIDDEN,
    DELEGATION_COUNT_LIMIT_EXCEEDED,

    // api
    BAD_FORMAT,
    EXPIRED_TOKENб,

    // poll
    POLL_NOT_FOUND,            // опрос не найден
    POLL_STATUS_ERROR,         // недопустимый статус опроса (новый или закрытый опрос)
    POLL_ALREADY_ANSWERED,     // попытка повторно ответить на опрос
    POLL_QUESTION_REQUIRED,    // отсутствует ответ на обязательный вопрос
    POLL_TOO_MANY_ANSWERS,     // для текстового вопроса и вопроса с одним значением должен быть один ответ
    POLL_TEXT_EXPECTED,        // выбран вариант ответа, в котором подразумевается ввод пользователя, но текста нет
    POLL_TEXT_LIMIT_EXCEEDED,  // превышен размер вводимого пользователем текста
    POLL_TITLE_REQUIRED,       // Недопустимое значение необходимого параметра запроса
    POLL_QUESTION_NOT_FOUND,                 // Вопрос не найден
    POLL_QUESTION_TEXT_SIZE_INVALID,         // Недопустимый размер текстового поля вопроса
    POLL_QUESTION_DESCRIPTION_SIZE_INVALID,  // Недопустимый размер описания опроса
    POLL_QUESTION_TYPE_INVALID,              // Недопустимый тип вопроса
    POLL_OPTION_NOT_FOUND,

    // all about url
    URL_INFO_NOT_AVAILABLE,    // сайт не проиндексирован или отсутствуют данные, поэтому раздел недоступен
    URL_INFO_ERROR,            // Ошибка при обработке запроса
    URL_INFO_NO_SUCH_REPORT,   // Запрашиваемый отчет отсутствует

    // www main mirror
    MAIN_MIRROR_WWW_STATUS_IS_INCONSISTENT, // Заявка на изменение главного зеркала сайта противоречит заявке от WWW!WWW зеркала сайта
    HOST_IS_ALREADY_MAIN_MIRROR,            // Заявка на отклейку подана для главного зеркала сайта
    DESIRED_MAIN_MIRROR_IS_NOT_ALLOWED,     // Запрашиваемое главное зеркало не подтверждено и не является www!www/https дублем сайта

    //seo links
    SEO_LINKS_MODIFICATION_NOT_ALLOWED
    ;

    @Override
    public Integer getId() {
        return null;
    }
}
