package ru.yandex.wmconsole.util;

import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * Адаптер для даты с временем
 * User: azakharov
 * Date: 13.03.12
 * Time: 13:54
 */
public class DateTimeXmlAdapter extends XmlAdapter<String, Date> {
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public String marshal(Date date) throws Exception {
        return DATE_TIME_FORMAT.format(date);
    }

    @Override
    public Date unmarshal(String dateString) throws Exception {
        return DATE_TIME_FORMAT.parse(dateString);
    }
}
