package ru.yandex.wmconsole.util;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

/**
 * User: azakharov
 * Date: 28.08.12
 * Time: 18:28
 */
public class FileUtil {
    public static void saveToAFile(String line, String path) throws InternalException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(path, true));
            writer.write(line);
            writer.newLine();
        } catch (IOException e) {
            throw new InternalException(InternalProblem.WRITE_FILE_ERROR,
                    "Failed to save string \"" + line + "\" to a file " + path, e);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    // ignore
                }
            }
        }
    }
}
