package ru.yandex.wmconsole.util;

import java.util.Collection;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

public class HostCollectionWrapper extends XmlConvertableCollectionWrapper {
    private static final String TAG_NAME = "name";

    private final String hostname;

    public HostCollectionWrapper(Collection<? extends XmlConvertable> collection, String hostname, long hostId) {
        super(collection, "host", "id", Long.toString(hostId));
        this.hostname = hostname;
    }

    public HostCollectionWrapper(Collection<? extends XmlConvertable> collection, BriefHostInfo briefHostInfo) {
        this(collection, briefHostInfo.getName(), briefHostInfo.getId());
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putHostnameTag(result, TAG_NAME, hostname);
        super.doToXml(result);
    }
}
