package ru.yandex.wmconsole.util;

import java.net.IDN;

import ru.yandex.common.util.xml.XmlConvertable;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

public class HostElementWrapper extends XmlDataWrapper<XmlConvertable> {
    private static final String TAG_HOST = "host";
    private static final String TAG_NAME = "name";
    private static final String TAG_PUNYCODE_NAME = "punycode-name";
    private static final String ATTRIBUTE_ID = "id";
    private final String hostName;

    public HostElementWrapper(XmlConvertable element, BriefHostInfo briefHostInfo) {
        super(element, TAG_HOST, ATTRIBUTE_ID, Long.toString((briefHostInfo == null) ? -1 : briefHostInfo.getId()));
        this.hostName = (briefHostInfo == null) ? "" : briefHostInfo.getName();
    }

    public HostElementWrapper(XmlConvertable element, String hostName) {
        super(element, TAG_HOST, ATTRIBUTE_ID, Long.toString(-1));
        this.hostName = hostName;
    }

    public HostElementWrapper(XmlConvertable element, BriefHostInfo briefHostInfo, String rootTagName) {
        super(element, rootTagName, ATTRIBUTE_ID, Long.toString((briefHostInfo == null) ? -1 : briefHostInfo.getId()));
        this.hostName = (briefHostInfo == null) ? "" : briefHostInfo.getName();
    }

    @Override
    protected void doToXml(StringBuilder result) {
        putHostnameTag(result, TAG_NAME, hostName);
        putTag(result, TAG_PUNYCODE_NAME, IDN.toASCII(hostName));
        if (data != null) {
            data.toXml(result);
        }
    }
}
