package ru.yandex.wmconsole.util;

import org.apache.commons.io.IOUtils;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * User: azakharov
 * Date: 11.06.14
 * Time: 12:53
 */
public class RsyncUtil {

    public static void rsync(final String fromUri, final String toUri, final String rsyncFlags, final String rsyncPassword) throws InternalException {
        final String [] flags = rsyncFlags.split(" ");
        final ArrayList<String> cmdList = new ArrayList<>();
        cmdList.add("rsync");
        cmdList.addAll(Arrays.asList(flags));
        cmdList.add(fromUri);
        cmdList.add(toUri);
        String [] cmdArray = new String[cmdList.size()];
        cmdArray = cmdList.toArray(cmdArray);
        String [] envp = new String[] {"RSYNC_PASSWORD=" + rsyncPassword};
        try {
            final Process p = Runtime.getRuntime().exec(cmdArray, envp);
            int val = p.waitFor();
            if (val != 0) {
                final String message = "rsync exit code is nonzero: " + val + ", error:" + IOUtils.toString(p.getErrorStream());
                throw new InternalException(InternalProblem.READ_FILE_ERROR, message);
            }
        } catch (IOException e) {
            throw new InternalException(InternalProblem.READ_FILE_ERROR, "rsync throws IOException");
        } catch (InterruptedException e) {
            throw new InternalException(InternalProblem.READ_FILE_ERROR, "InterruptedException on waitFor");
        }
    }

    public static boolean resourceExists(final String rsyncShareUri, final String rsyncFlags, final String rsyncPassword) throws InternalException {
        final String [] flags = rsyncFlags.split(" ");
        final ArrayList<String> cmdList = new ArrayList<>();
        cmdList.add("rsync");
        cmdList.addAll(Arrays.asList(flags));
        cmdList.add(rsyncShareUri);
        String [] cmdArray = new String[cmdList.size()];
        cmdArray = cmdList.toArray(cmdArray);
        String [] envp = new String[] {"RSYNC_PASSWORD=" + rsyncPassword};
        try {
            final Process p = Runtime.getRuntime().exec(cmdArray, envp);
            int val = p.waitFor();
            return val == 0;
        } catch (IOException e) {
            throw new InternalException(InternalProblem.READ_FILE_ERROR, "rsync throws IOException");
        } catch (InterruptedException e) {
            throw new InternalException(InternalProblem.READ_FILE_ERROR, "InterruptedException on waitFor");
        }
    }
}
