package ru.yandex.wmconsole.util;

import java.util.HashSet;
import java.util.Set;

/**
 * Common util methods for servantlets.
 * <p/>
 * User: baton
 * Date: 05.04.2007
 * Time: 21:10:00
 */
public class ServantletUtil {

    private static final Set<String> yandexMailSuffix = new HashSet<String>();

    static {
        yandexMailSuffix.add("yandex.ru");
        yandexMailSuffix.add("ya.ru");
        yandexMailSuffix.add("yandex.by");
        yandexMailSuffix.add("yandex.com");
        yandexMailSuffix.add("yandex.kz");
        yandexMailSuffix.add("narod.ru");
        yandexMailSuffix.add("yandex.ua");
    }

    public static boolean isErrorCodeSafeToShow(UrlErrorOrGroup error) {
        if (!error.isGroup()) {
            int errorCode = error.getPrimitiveCodes()[0];
            Integer errorGroupForCode = UrlErrorGrouper.getInstance().mapErrorToErrorGroup(errorCode);
            if (errorGroupForCode == null) {
                // is restricted
                return false;
            }
            if (errorGroupForCode != errorCode) {
                // belongs to group, but asked separately
                return false;
            }
        }

        return true;
    }

    public static String prepareLogin(String login) {
        if (login.contains("@")) {
            String suffix = login.split("@")[1];
            if (yandexMailSuffix.contains(suffix)) {
                return login.substring(0, login.length() - suffix.length() - 1);
            }
        }
        return login;
    }
}
