package ru.yandex.wmconsole.util;

import java.util.Map;

import ru.yandex.common.util.db.OrderByClause;
import ru.yandex.common.util.parameters.ParametersSource;

/**
 * User: baton
 * Date: 16.08.2007
 * Time: 17:59:10
 */
public class TreeOrderByClause extends OrderByClause {
    public static final String ORDER_BY_PARAM_NAME = "tree_order_by";
    public static final String ORDER_BY_MODE_PARAM_NAME = "tree_order_by_mode";

    public TreeOrderByClause(String columnName, boolean ascending) {
        super(columnName, ascending);
    }

    public TreeOrderByClause(String orderByClause) {
        super(orderByClause);
    }

    public TreeOrderByClause(ParametersSource paramSource) {
        super(paramSource);
    }

    public TreeOrderByClause(ParametersSource paramSource, String defaultOrderBy, boolean defaultIsAscending, Map<String, String> columnNameCorrecpondence) {
        super(paramSource, defaultOrderBy, defaultIsAscending, columnNameCorrecpondence);
    }

    @Override
    public String getOrderByParamName() {
        return ORDER_BY_PARAM_NAME;
    }

    @Override
    public String getOrderByModeParamName() {
        return ORDER_BY_MODE_PARAM_NAME;
    }
}
