package ru.yandex.wmconsole.util;

/**
 * Represents index error or index error group.
 * <p/>
 * User: baton
 * Date: 11.04.2007
 * Time: 15:37:29
 * To change this template use File | Settings | File Templates.
 */
public class UrlErrorOrGroup {
    // non-zero
    private final int code;

    private final UrlErrorGrouper.UrlErrorGroup group;

    public UrlErrorOrGroup(int code) {
        if (code < 0) {
            group = UrlErrorGrouper.getGroupByGroupId(code);
            if (group == null) {
                throw new IllegalArgumentException("No group found with such group id.");
            }
        } else {
            group = null;
        }
        this.code = code;
    }

    public boolean isGroup() {
        return code < 0;
    }

    public int getCode() {
        return code;
    }

    public int getPrimitiveCodesCount() {
        if (isGroup()) {
            return group.ids.length;
        } else {
            return 1;
        }
    }

    /**
     * For group: returns array of primitive codes.
     * For primitive code: returns itself.
     *
     * @return ...
     */
    public int[] getPrimitiveCodes() {
        if (isGroup()) {
            return group.ids;
        } else {
            return new int[]{code};
        }
    }
}
