package ru.yandex.wmconsole.util;

import ru.yandex.wmconsole.data.info.XMLSerpLinkInfo;
import ru.yandex.wmconsole.data.xmlsearch.RegionSearchRequest;
import ru.yandex.wmconsole.data.xmlsearch.SerpLinksRequest;
import ru.yandex.wmtools.common.data.xmlsearch.*;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.util.TimeFilter;

/**
 * @author avhaliullin
 */
public class XMLSearchRequests {
    public static XmlSearchRequest createLinksCount(String hostName, String path, Integer lastDays) throws UserException {
        return new LinksCountRequest(hostName, path, TimeFilter.create(lastDays), 0, 10);
    }

    public static XmlSearchRequest createLinksGroups(String hostName, String path, Integer lastDays, int pageNum, int pageSize) throws UserException {
        return new LinksGroupsRequest(hostName, path, TimeFilter.create(lastDays), pageNum, pageSize);
    }

    public static XmlSearchRequest createLinksFromHost(String hostName, String path, String fromHost, Integer lastDays, int pageNum, int pageSize) throws UserException {
        return new LinksFromHostRequest(hostName, path, TimeFilter.create(lastDays), fromHost, pageNum, pageSize);
    }

    public static XmlSearchRequest createInternalLinks(String hostName, String path, Integer lastDays, int pageNum, int pageSize) throws UserException {
        return new IntLinksRequest(hostName, path, TimeFilter.create(lastDays), pageNum, pageSize);
    }

    public static XmlSearchRequest createIndexedUrls(String hostName, String path, Integer lastDays, int pageNum, int pageSize) throws UserException {
        return new UrlsRequest(hostName, path, TimeFilter.create(lastDays), pageNum, pageSize);
    }

    public static XmlSearchRequest createFastIndexCount(String hostName, String path) throws UserException {
        return new FastIndexCountRequest(hostName, path);
    }

    public static XmlSearchRequest createSerpLinks(String sectionName) {
        return new SerpLinksRequest(sectionName);
    }

    public static XmlSearchRequest createSerpLinks(String hostName, String path) throws UserException, InternalException {
        return createSerpLinks(XMLSerpLinkInfo.getSectionName(hostName, path));
    }

    public static XmlSearchRequest createRegionsSearch(String query, long region, int pageNum, int pageSize) {
        return new RegionSearchRequest(query, region, pageNum, pageSize);
    }

}
