package ru.yandex.wmconsole.util.file.comparator;

import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

import java.util.Comparator;

/**
 * User: azakharov
 * Date: 31.07.13
 * Time: 18:26
 */
public class FileComparator<K, T extends TextFileRecord<K>> {

    public void compare(TextFileReader<T> oldFile,
                            TextFileReader<T> newFile,
                            OneSideHandler<T> urlInOldFileHandler,
                            EqualsRecordHandler<T> urlInBothFilesHandler,
                            OneSideHandler<T> urlInNewFileHandler,
                            Comparator<K> comparator) throws UserException, InternalException, InterruptedException {
        T oldFileRecord = oldFile.next();
        T newFileRecord = newFile.next();
        while (oldFileRecord != null && newFileRecord != null) {
            int res = comparator.compare(oldFileRecord.getKey(), newFileRecord.getKey());
            if (res == 0) {
                urlInBothFilesHandler.handle(oldFileRecord, newFileRecord);
                oldFileRecord = oldFile.next();
                newFileRecord = newFile.next();
            } else if (res < 0) {
                // old url < new url
                urlInOldFileHandler.handle(oldFileRecord);
                oldFileRecord = oldFile.next();
            } else {
                // old url > new url
                urlInNewFileHandler.handle(newFileRecord);
                newFileRecord = newFile.next();
            }
        }

        // removing the rest of the records from old file
        while (oldFileRecord != null) {
            urlInOldFileHandler.handle(oldFileRecord);
            oldFileRecord = oldFile.next();
        }

        // adding the rest of the records from new file
        while (newFileRecord != null) {
            urlInNewFileHandler.handle(newFileRecord);
            newFileRecord = newFile.next();
        }
    }
}
