package ru.yandex.wmconsole.util.file.comparator.impl;

import ru.yandex.wmconsole.util.file.comparator.TextFileRecord;

import java.net.URL;

/**
 * User: azakharov
 * Date: 31.07.13
 * Time: 18:36
 */
public class UrlRecord implements TextFileRecord<URL> {
    private final URL url;
    private final UrlProblemEnum problem;
    private final UrlSourceEnum source;
    private final Integer httpCode;

    protected UrlRecord(URL url, UrlSourceEnum source, UrlProblemEnum problem, Integer httpCode) {
        this.url = url;
        this.source = source;
        this.problem = problem;
        this.httpCode = httpCode;
    }

    @Override
    public URL getKey() {
        return url;
    }

    public Integer getHttpCode() {
        return httpCode;
    }

    public UrlProblemEnum getProblem() {
        return problem;
    }

    public UrlSourceEnum getSource() {
        return source;
    }
}
