package ru.yandex.wmconsole.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author baton
 */
class AutoVerificationUnit {
    private static final List<AutoVerificationUnit> list = new ArrayList<AutoVerificationUnit>();

    static {
        //list.add(new AutoVerificationUnit(4, ".narod.ru", true, true, true));
        list.add(new AutoVerificationUnit(13, ".moikrug.ru", false, false, true));
        list.add(new AutoVerificationUnit(26, ".ya.ru", true, false, true));
        //list.add(new AutoVerificationUnit(46, ".narod2.ru", true, false, true));
        //list.add(new AutoVerificationUnit(46, ".narod.ru", true, false, false));
    }

    public static Collection<AutoVerificationUnit> listAll() {
        return list;
    }

    private final int serviceId;
    private final String domain;
    private final boolean wwwPrefixAllowed;
    private final boolean checkLoginAtService;
    private final boolean addToAlreadyVerifiedHosts;

    private AutoVerificationUnit(int serviceId, String domain, boolean wwwPrefixAllowed, boolean checkLoginAtService, boolean addToAlreadyVerifiedHosts) {
        this.serviceId = serviceId;
        this.domain = domain;
        this.wwwPrefixAllowed = wwwPrefixAllowed;
        this.checkLoginAtService = checkLoginAtService;
        this.addToAlreadyVerifiedHosts = addToAlreadyVerifiedHosts;
    }

    public int getServiceId() {
        return serviceId;
    }

    public String getDomain() {
        return domain;
    }

    public boolean isWwwPrefixAllowed() {
        return wwwPrefixAllowed;
    }

    public boolean isCheckLoginAtService() {
        return checkLoginAtService;
    }

    public boolean isAddToAlreadyVerifiedHosts() {
        return addToAlreadyVerifiedHosts;
    }
}
