package ru.yandex.wmconsole.verification;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author baton
 */
public class CheckHtmlFileContentHandler extends DefaultHandler {
    private boolean found = false;
    private String faultLog = null;
    private boolean insideBody = false;
    private boolean foundBody = false;

    private final StringBuilder foundContent = new StringBuilder();
    private final String requiredContent;

    public CheckHtmlFileContentHandler(String content) {
        this.requiredContent = content;
    }

    public boolean isFound() {
        return found && (faultLog == null);
    }

    public String getFaultLog() {
        return faultLog;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
//        log.debug("SAX. Checking tag: found tag START with name = '" + localName + "'");

        if (faultLog != null) {
            // already found an error. Do nothing.
//            log.debug("already found an error. Do nothing.");
            return;
        }

        if (insideBody) {
            // there must be no other requiredContent in body, except verification information. Fault!
            faultLog = "Unexpected tag <" + localName + "> inside <body>";
//            log.debug(faultLog);
            return;
        }

        if ("body".equalsIgnoreCase(localName)) {
            if (foundBody) {
                // it is the second 'body' that we found, but expected only one!
                faultLog = "Second <body> tag found in file, while expected only one";
//                log.debug(faultLog);
                return;
            }

            insideBody = true;
            foundBody = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
//        log.debug("SAX. Checking tag: found tag FINISH with name = '" + localName + "'");
        if (faultLog != null) {
            // already found an error. Do nothing.
//            log.debug("already found an error. Do nothing.");
            return;
        }

        if (!insideBody) {
            // this is not interesting for us. Just ignore.
//            log.debug("this is not interesting for us. Just ignore.");
            return;
        }

        if ("body".equalsIgnoreCase(localName)) {
            // ok, closing <body>
//            log.debug("ok, closing <body>");
            insideBody = false;
        } else {
            // there must be no other requiredContent in body, except verification information. Fault!
            faultLog = "Unexpected tag </" + localName + "> inside <body>";
//            log.debug(faultLog);
        }
    }

    @Override
    public void characters(char ch[], int start, int length) throws SAXException {
//        log.debug("SAX. Checking CHARACTERS");
        if (faultLog != null) {
            // already found an error. Do nothing.
//            log.debug("already found an error. Do nothing.");
            return;
        }

        if (!insideBody) {
            // this is not interesting for us. Just ignore.
//            log.debug("this is not interesting for us. Just ignore.");
            return;
        }

        // we are inside body! concat letters to found
        foundContent.append(ch, start, length);
//        log.debug("FoundContent: " + foundContent);

        if (!requiredContent.startsWith(foundContent.toString().trim())) {
            // required and found content differ!
            faultLog = "Expected '" + requiredContent + "', but found '" + foundContent + "' inside <body>";
//            log.debug(faultLog);
            return;
        }

        if (requiredContent.equals(foundContent.toString().trim())) {
            // yeah!
//            log.debug("yeah!");
            found = true;
        }

//        log.debug("go away...");
    }
}
