package ru.yandex.wmconsole.verification;

import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;

/**
 * @author ailyin
 */
public class ManualVerifier implements Verifier {
    @Override
    public UsersHostsInfo verify(UsersHostsInfo info) {//this method isn't called actually
        return UsersHostsInfo.createVerifiedNow(info);
    }

    @Override
    public UsersHostsInfo cancel(UsersHostsInfo info) {
        return UsersHostsInfo.createNotVerifiedNow(info, VerificationStateEnum.MANUAL_VERIFICATION_CANCELLED,
                "Some user pressed 'reverify' and that cancelled manual verification.");
    }
}
