package ru.yandex.wmconsole.verification.whois.handlers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import ru.yandex.wmconsole.verification.whois.WhoisRecordHandler;

/**
 * @author avhaliullin
 */
public class SimpleWhoisHandler implements WhoisRecordHandler {
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:.*\\s)?e-?mail:?[\\s.]*\\b([\\w._%+-]+@[\\w0-9.-]+\\.[\\w]{2,4})\\b", Pattern.CASE_INSENSITIVE);

    @Override
    public String nextLine(String line) {
        Matcher m = EMAIL_PATTERN.matcher(line);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}
