package ru.yandex.wmconsole.data.info;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * User: azakharov
 * Date: 18.01.13
 * Time: 17:27
 */
public class MetaInfo {
    private Map<String, Boolean> primaryKeys = new LinkedHashMap<String, Boolean>();
    private Map<TableColumn, TableColumn> foreignKeys = new LinkedHashMap<TableColumn, TableColumn>();

    public MetaInfo() {
    }

    public Map<String, Boolean> getPrimaryKeys() {
        return primaryKeys;
    }

    public Map<TableColumn, TableColumn> getForeignKeys() {
        return foreignKeys;
    }

    /**
     * Получение мэпа из таблицы, на которую ссылается данная таблица, в список колонок данной таблицы,
     * которые ссылаются на ключ мэпа
     *
     * Пример:
     * T1.FA -> T2.A
     * T1.FB -> T2.B
     * T1.FC -> T3.C
     * Результат:
     * {{T3, {FC}}, {T2, {FA, FB}}}
     *
     * @return {<ReferredTable,[ReferringTableColumns]>}
     */
    public Map<String, List<TableColumn>> getReferencingColumnsForTable() {
        Map<String, List<TableColumn>> fkToTheSameTable = new LinkedHashMap<String, List<TableColumn>>();
        for (Map.Entry<TableColumn, TableColumn> entry : getForeignKeys().entrySet()) {
            String referredTableName = entry.getValue().getTableName();
            List<TableColumn> foreignKeys = fkToTheSameTable.get(referredTableName);
            if (foreignKeys == null) {
                foreignKeys = new LinkedList<TableColumn>();
                fkToTheSameTable.put(referredTableName, foreignKeys);
            }
            foreignKeys.add(entry.getKey());
        }
        return fkToTheSameTable;
    }

    public void setPrimaryKeys(Map<String, Boolean> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void putForeignKey(TableColumn from, TableColumn to) {
        foreignKeys.put(from, to);
    }
}
