package ru.yandex.wmconsole.data.info;

/**
 * User: azakharov
 * Date: 18.01.13
 * Time: 17:28
 */
public class TableColumn {
    private String tableName;
    private String columnName;

    public TableColumn(String tableName, String columnName) {
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public String getTableName() {
        return tableName;
    }

    public String getColumnName() {
        return columnName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TableColumn that = (TableColumn) o;

        if (!columnName.equals(that.columnName)) return false;
        if (!tableName.equals(that.tableName)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = tableName.hashCode();
        result = 31 * result + columnName.hashCode();
        return result;
    }
}
