package ru.yandex.wmconsole.data.partition;

import ru.yandex.wmconsole.data.info.HostDbHostInfo;

/**
 * User: azakharov
 * Date: 24.12.12
 * Time: 13:36
 */
public class WMCCopyPartition extends WMCPartition {

    private boolean production;

    public WMCCopyPartition(HostDbHostInfo hostInfo, Long userId) {
        super(hostInfo, userId);
    }

    public WMCCopyPartition(Long hostDbHostId, String hostname, Long userId, boolean production) {
        super(hostDbHostId, hostname, userId);
        setProduction(production);
    }

    public WMCCopyPartition(int databaseIndex, boolean production) {
        super(databaseIndex);
        setProduction(production);
    }

    public WMCCopyPartition(int databaseIndex, long partIndex) {
        super(databaseIndex, partIndex);
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    public boolean isProduction() {
        return production;
    }
}
