package ru.yandex.wmconsole.servantlet;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.wrappers.StringWrapper;
import ru.yandex.wmconsole.service.DbCopyService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;

/**
 * Copies all host info from production db to development db
 *
 * User: azakharov
 * Date: 24.12.12
 * Time: 13:45
 */
public class CopyHostServantlet extends WMCAuthenticationServantlet {
    
    private static final String PARAM_HOST = "host";
    private static final String PARAM_COPY_TOP_DATA = "top-data";
    private static final String PARAM_COPY_EXCLUDED_PAGES = "excluded-pages";
    private static final String PARAM_COPY_HOSTMON_DATA = "hostmon-data";
    private static final String PARAM_COPY_INDEX_HISTORY = "index-history";

    private DbCopyService dbCopyService;

    @Override
    protected void doProcess(ServRequest request, ServResponse response, long userId) throws UserException, InternalException {
        final String host = getRequiredStringParam(request, PARAM_HOST);
        final Boolean copyExcludedPages = request.getCheckBoxParamAsBoolean(PARAM_COPY_EXCLUDED_PAGES, false);
        final Boolean copyTopData = request.getCheckBoxParamAsBoolean(PARAM_COPY_TOP_DATA, false);
        final Boolean copyHostMonData = request.getCheckBoxParamAsBoolean(PARAM_COPY_HOSTMON_DATA, false);
        final Boolean copyIndexHistory = request.getCheckBoxParamAsBoolean(PARAM_COPY_INDEX_HISTORY, false);
        dbCopyService.copyFrom(host, copyExcludedPages, copyTopData, copyHostMonData, copyIndexHistory);
        response.addData(new StringWrapper("OK", "copy-status"));
    }

    @Required
    public void setDbCopyService(DbCopyService dbCopyService) {
        this.dbCopyService = dbCopyService;
    }
}
