package ru.yandex.wmconsole.servantlet;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.service.DbCopyService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;

/**
 * User: azakharov
 * Date: 05.02.13
 * Time: 19:56
 */
public class CopyRegionsServantlet extends AbstractServantlet {
    private static Logger log = Logger.getLogger(CopyRegionsServantlet.class);

    private DbCopyService dbCopyService;

    @Override
    protected void doProcess(ServRequest req, ServResponse res) throws UserException, InternalException {
        log.info("updating db 0");
        dbCopyService.updateDicRegions(0);
        log.info("updating db 1");
        dbCopyService.updateDicRegions(1);
        log.info("updating db...DONE");
    }

    @Required
    public void setDbCopyService(DbCopyService dbCopyService) {
        this.dbCopyService = dbCopyService;
    }
}
