package ru.yandex.wmconsole.service;

import ru.yandex.wmconsole.data.partition.WMCCopyPartition;
import ru.yandex.wmtools.common.data.partition.IPartition;
import ru.yandex.wmtools.common.service.AbstractDbService;
import ru.yandex.wmtools.common.service.JdbcConnectionWrapperService;
import ru.yandex.wmtools.common.util.IServiceJdbcTemplate;


/**
 * @author avhaliullin
 */
public class CheatJdbcConnectionWrapper extends JdbcConnectionWrapperService {
    private AbstractDbService dev;
    private AbstractDbService prod;

    @Override
    public IServiceJdbcTemplate getJdbcTemplate(final IPartition partition) {
        if (!(partition instanceof WMCCopyPartition)) {
            throw new UnsupportedOperationException("Partition class not supported");
        }
        WMCCopyPartition p = (WMCCopyPartition) partition;
        if (p.isProduction()) {
            return prod.getJdbcTemplate(partition);
        } else {
            return dev.getJdbcTemplate(partition);
        }
    }

    public void setDev(AbstractDbService dev) {
        this.dev = dev;
    }

    public void setProd(AbstractDbService prod) {
        this.prod = prod;
    }
}
