#!/bin/bash
./dev_prepare.sh

SERVANT=`cat servant.name`
SERVANT_LOCATION="/home/$(whoami)/my_servants/wmcdbcopy"
SERVANT_PID_FILE=${SERVANT_LOCATION}/../$SERVANT.pid

echo 'Starting servant: '
echo $SERVANT

JAVA_HOME=/usr/local/java6
PATH="$JAVA_HOME/bin:$PATH"
LANG=en_US.UTF-8

#JLIB=${JLIB:=$HOME/svn/market/libraries/trunk/common-lib}

#CLASSPATH=`find lib $JLIB -maxdepth 3 -name '*.jar' -exec echo -n {}":" \;`$CLASSPATH

#echo $CLASSPATH

export PATH LANG JAVA_HOME CLASSPATH

java_exec=$JAVA_HOME/bin/java

ln -fs $java_exec $JAVA_HOME/bin/tmp/$SERVANT

DEBUG_OPTIONS="-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=33539"

exec $JAVA_HOME/bin/tmp/$SERVANT -ea -classpath "lib/*" $flags \
     ${DEBUG_OPTIONS} \
     -Xms64m -Xmx128m -XX:+UseParallelGC \
     -Dhost.name=`/bin/hostname` \
     -Djna.library.path=lib/lib \
     -Dfile.encoding=UTF-8 \
     -Djavax.xml.transform.TransformerFactory=com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl \
     ru.yandex.common.util.application.Main >> ${SERVANT_LOCATION}/${SERVANT}_sh.log 2>&1 &

echo $! > ${SERVANT_PID_FILE}
echo "Servant started: pid="`cat ${SERVANT_PID_FILE}`
