package ru.yandex.wmconsole.data;

import ru.yandex.common.framework.user.UserInfo;

import java.util.Date;

/**
 * @author avhaliullin
 */
public class DelegationNotificationInfo {
    private final long hostId;
    private final long userIdGot;
    private final long userIdGave;
    private final boolean mayRedelegate;
    private final boolean givingDelegation;
    private final Date delegationDate;
    private UserInfo userGaveInfo;
    private String hostName;

    public DelegationNotificationInfo(long hostId, long userIdGot, long userIdGave, boolean mayRedelegate, boolean givingDelegation, Date delegationDate, UserInfo userInfo, String hostName) {
        this.hostId = hostId;
        this.userIdGot = userIdGot;
        this.userIdGave = userIdGave;
        this.mayRedelegate = mayRedelegate;
        this.givingDelegation = givingDelegation;
        this.delegationDate = delegationDate;
        this.userGaveInfo = userInfo;
        this.hostName = hostName;
    }

    public DelegationNotificationInfo(long hostId, long userIdGot, long userIdGave, boolean mayRedelegate, boolean givingDelegation, Date delegationDate) {
        this(hostId, userIdGot, userIdGave, mayRedelegate, givingDelegation, delegationDate, null, null);
    }


    public long getHostId() {
        return hostId;
    }

    public long getUserIdGot() {
        return userIdGot;
    }

    public boolean isMayRedelegate() {
        return mayRedelegate;
    }

    public Date getDelegationDate() {
        return delegationDate;
    }

    public long getUserIdGave() {
        return userIdGave;
    }

    public UserInfo getUserGaveInfo() {
        return userGaveInfo;
    }

    public void setUserGaveInfo(UserInfo userGaveInfo) {
        this.userGaveInfo = userGaveInfo;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isGivingDelegation() {
        return givingDelegation;
    }
}
