package ru.yandex.wmconsole.data;

import java.util.Date;

/**
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 13.01.12
 */
public class HostStatusChangedNotificationInfo implements GroupableByHostData {
    private final long hostId;
    private final int status;
    private final String spiderIp;
    private final Date lastAccess;

    public HostStatusChangedNotificationInfo(long hostId, int status, String spiderIp, Date lastAccess) {
        this.hostId = hostId;
        this.status = status;
        this.spiderIp = spiderIp;
        this.lastAccess = lastAccess;
    }

    public int getStatus() {
        return status;
    }

    @Override
    public Long getHostId() {
        return hostId;
    }

    public String getSpiderIp() {
        return spiderIp;
    }

    public Date getLastAccess() {
        return lastAccess;
    }
}
