package ru.yandex.wmconsole.data;

import java.util.Date;

/**
 * Базовый класс для нотификаций о различных
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 20.02.12
*/
public abstract class MalwareNotificationInfo implements GroupableByHostData {
    protected final String url;
    protected final Long hostId;
    protected final Date receiveTime;

    public MalwareNotificationInfo(String url, Long hostId, Date receiveTime) {
        this.url = url;
        this.hostId = hostId;
        this.receiveTime = receiveTime;
    }

    public String getUrl() {
        return url;
    }

    @Override
    public Long getHostId() {
        return hostId;
    }

    public Date getReceiveTime() {
        return receiveTime;
    }
}
