package ru.yandex.wmconsole.data;

import java.util.Date;

import ru.yandex.common.framework.user.UserInfo;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;

/**
 * @author avhaliullin
 */
public class VerificationNotificationInfo implements GroupableByHostData {
    private final Long hostId;
    private final  Long userId;
    private UserInfo userInfo;
    private String hostName;
    private final Date verificationDate;
    private final VerificationTypeEnum type;

    public VerificationNotificationInfo(Date verificationDate, long hostId, long userId, String hostName, UserInfo userInfo, VerificationTypeEnum type) {
        this.verificationDate = verificationDate;
        this.hostId = hostId;
        this.userId = userId;
        this.userInfo = userInfo;
        this.hostName = hostName;
        this.type = type;
    }

    public VerificationNotificationInfo(Date verificationDate, long hostId, long userId, VerificationTypeEnum type) {
        this(verificationDate, hostId, userId, null, null, type);
    }

    @Override
    public Long getHostId() {
        return hostId;
    }

    public long getUserId() {
        return userId;
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public Date getVerificationDate() {
        return verificationDate;
    }

    public VerificationTypeEnum getType() {
        return type;
    }

    public UserInfo getUserInfo() {
        return userInfo;
    }
}
