package ru.yandex.wmconsole.notifier.handler;

import java.util.Date;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.DelegationNotificationInfo;
import ru.yandex.wmconsole.data.NotificationTypeEnum;
import ru.yandex.wmconsole.service.DelegationNotificationService;
import ru.yandex.wmconsole.service.NotificationService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author avhaliullin
 */
public class DelegationNotificationHandler implements Handler {
    private static final Logger log = LoggerFactory.getLogger(DelegationNotificationHandler.class);

    private DelegationNotificationService delegationNotificationService;
    private NotificationService notificationService;

    @Override
    public void handleNotification(String xmlData) {
        throw new UnsupportedOperationException("handleNotification not supported for delegation notification");
    }

    @Override
    public void internalHandle(String... params) {
        Long hostId = Long.parseLong(params[0]);
        Long userGotId = Long.parseLong(params[1]);
        Long userGaveId = Long.parseLong(params[2]);
        Boolean mayRedelegate = Boolean.parseBoolean(params[3]);
        Boolean givingDelegation = Boolean.parseBoolean(params[4]);
        Date date = new Date(Long.parseLong(params[5]));

        if (hostId == null || userGaveId == null || userGotId == null || mayRedelegate == null || givingDelegation == null || date == null) {
            log.error(String.format("Bad params: " +
                    (hostId == null ? "hostId = null " : "") +
                    (userGaveId == null ? "userGaveId = null " : "") +
                    (userGotId == null ? "userGotId = null " : "") +
                    (mayRedelegate == null ? "mayRedelegate = null " : "") +
                    (givingDelegation == null ? "givingDelegation = null " : "") +
                    (date == null ? "date = null " : "")));
        }

        DelegationNotificationInfo info = new DelegationNotificationInfo(hostId, userGotId, userGaveId, mayRedelegate, givingDelegation, date);
        long issueId;
        try {
            issueId = delegationNotificationService.insertDelegationNotification(info);
        } catch (InternalException e) {
            log.error("Failed to insert delegation notification", e);
            return;
        }

        try {
            notificationService.insertNotificationForUser(NotificationTypeEnum.DELEGATION, issueId, userGotId, date);
        } catch (InternalException e) {
            log.error("Failed to insert delegation notification, issueId = " + issueId);
        }
    }

    @Override
    public void handleInternalNotification(Map <String, String> params) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    @Required
    public void setDelegationNotificationService(DelegationNotificationService delegationNotificationService) {
        this.delegationNotificationService = delegationNotificationService;
    }

    @Required
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}
