package ru.yandex.wmconsole.notifier.handler;

import java.util.Map;

/**
 * Handles notification cases of exact type happened in system.
 * Fills tables that keep information on notification case.
 * Lears users interested in notifications.
 * Adds notifications to the notification queue.
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public interface Handler {
    public void handleNotification(String xmlData);
    public void internalHandle(String... params);
    public void handleInternalNotification(Map<String, String> params);
}
