package ru.yandex.wmconsole.notifier.handler;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 20.01.12
 */
public class MapParamUtil {
    public static String getRequiredStringParam(final Map<String, String> params, final String paramName) throws UserException {
        final String stringValue = params.get(paramName);
        if (stringValue == null) {
            throw new UserException(UserProblem.REQUIRED_PARAM_MISSED, "Required param missed: " + paramName, paramName);
        }
        return stringValue;
    }

    public static long getRequiredLongParam(final Map<String, String> params, final String paramName) throws UserException {
        final String stringValue = getRequiredStringParam(params, paramName);

        try {
            return Long.decode(stringValue);
        } catch (NumberFormatException e) {
            throw new UserException(UserProblem.ILLEGAL_VALUE_TYPE, "Invalid param: " + paramName, e, paramName, stringValue);
        }
    }

    public static int getRequiredIntParam(final Map<String, String> params, final String paramName) throws UserException {
        final String stringValue = getRequiredStringParam(params, paramName);

        try {
            return Integer.decode(stringValue);
        } catch (NumberFormatException e) {
            throw new UserException(UserProblem.ILLEGAL_VALUE_TYPE, "Invalid param: " + paramName, e, paramName, stringValue);
        }
    }

    public static Date getRequiredDateParam(final Map<String, String> params, String paramName) throws UserException {
        Date date = getDateParam(params, paramName);
        if (date == null) {
            throw new UserException(UserProblem.REQUIRED_PARAM_MISSED, "Required param missed: " + paramName, paramName);
        }
        return date;
    }

    public static byte getRequiredByteParam(final Map<String, String> params, final String paramName) throws UserException {
        String stringValue = getRequiredStringParam(params, paramName);

        try {
            return Byte.decode(stringValue);
        } catch (NumberFormatException e) {
            throw new UserException(UserProblem.ILLEGAL_VALUE_TYPE, "Invalid param: " + paramName, e, paramName, stringValue);
        }
    }

    public static String getStringParam(final Map<String, String> params, final String paramName) {
        final String stringValue = params.get(paramName);
        if (StringUtils.isEmpty(stringValue)) {
            return null;
        }

        return stringValue;
    }

    public static Date getDateParam(final Map<String, String> params, String paramName) throws UserException {
        String stringValue = params.get(paramName);
        if (StringUtils.isEmpty(stringValue)) {
            return null;
        }
        Date value;
        try {
            value = XmlDataWrapper.getDateFormat().parse(stringValue);
        } catch (ParseException e) {
            throw new UserException(UserProblem.ILLEGAL_VALUE_TYPE, "Invalid param: " + paramName, e, paramName, stringValue);
        }
        return value;
    }

    public static Long getLongParam(final Map<String, String> params, final String paramName) throws UserException {
        String stringValue = params.get(paramName);
        if (StringUtils.isEmpty(stringValue)) {
            return null;
        }

        try {
            return Long.decode(stringValue);
        } catch (NumberFormatException e) {
            throw new UserException(UserProblem.ILLEGAL_VALUE_TYPE, "Invalid param: " + paramName, e, paramName, stringValue);
        }
    }
}
