package ru.yandex.wmconsole.notifier.handler;

import java.util.EnumMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationTypeEnum;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class NotificationHandler {
    private static final Logger log = LoggerFactory.getLogger(NotificationHandler.class);

    private Map<NotificationTypeEnum, Handler> handlers;

    //TODO CREATE ABSTRACT HANDLER...
    public void handleNotification(NotificationTypeEnum type, String xmlData) {
        if (!handlers.containsKey(type)) {
            log.error("Notification type " + type + " handler is not supported!");
            return;
        }

        handlers.get(type).handleNotification(xmlData);
    }

    // TODO: перевести все обработчики внутренних нотификаций на использование метода handleInternalNotification и удалить этот метод из интерфейса
    // TODO: для этого нужно повторить методы getRequiredParam для Map с параметрами
    @Deprecated
    public void internalHandleNotification(NotificationTypeEnum type, String... params) {
        if (!handlers.containsKey(type)) {
            log.error("Notification type " + type + " handler is not supported!");
            return;
        }

        handlers.get(type).internalHandle(params);
    }

    public void handleInternalNotification(NotificationTypeEnum type, Map<String, String> params) {
        if (!handlers.containsKey(type)) {
            log.error("Notification type " + type + " handler is not supported!");
            return;
        }

        handlers.get(type).handleInternalNotification(params);
    }

    @Required
    public void setHandlers(Map<NotificationTypeEnum, Handler> handlers) {
        this.handlers = new EnumMap<NotificationTypeEnum, Handler>(handlers);
    }
}
