package ru.yandex.wmconsole.notifier.handler;

import java.util.Date;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationTypeEnum;
import ru.yandex.wmconsole.service.NotificationService;
import ru.yandex.wmconsole.service.SearchUpdateService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class SearchUpdateNotificationHandler implements Handler {
    private static final Logger log = LoggerFactory.getLogger(SearchUpdateNotificationHandler.class);

    private NotificationService notificationService;
    private SearchUpdateService searchUpdateService;

    public void internalHandleNotification() {
        try {
            Date date = new Date();
            Long issueId = fillTables(date);
            notificationService.insertNotificationForAll(NotificationTypeEnum.SEARCH_UPDATE, issueId, date);
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while inserting notification(s)", e);
        }
    }

    private Long fillTables(Date date) throws InternalException {
        return searchUpdateService.addSearchUpdate(date);
    }

    @Override
    public void handleNotification(String xmlData) {
        throw new UnsupportedOperationException("External search update handling not supported: use errorsgrow instead");
    }

    @Override
    public void internalHandle(String... params) {
        throw new UnsupportedOperationException("Internal handle not supported for SearchUpdate notification");
    }

    @Override
    public void handleInternalNotification(Map<String, String> params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Required
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @Required
    public void setSearchUpdateService(SearchUpdateService searchUpdateService) {
        this.searchUpdateService = searchUpdateService;
    }
}
