package ru.yandex.wmconsole.servantlet;

import java.util.List;

import ru.yandex.common.framework.core.ServRequest;
import ru.yandex.common.framework.core.ServResponse;
import ru.yandex.wmconsole.data.info.ShortHostInfo;
import ru.yandex.wmconsole.data.wrappers.ShortHostInfoWrapper;
import ru.yandex.wmconsole.service.UsersHostsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.servantlet.AbstractServantlet;
import ru.yandex.wmtools.common.util.XmlConvertableCollectionWrapper;

/**
 * Return all hosts verified by given user. CHEAT verifications are excluded.
 * @author senin
 */
public class HostsVerifiedByUserServantlet extends AbstractServantlet {
    private static final String PARAM_UID = "uid";
    private static final String TAG_HOSTLIST = "hostlist";

    private UsersHostsService usersHostsService;

    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }

    @Override
    protected void doProcess(ServRequest req, final ServResponse res) throws UserException, InternalException {
        checkService(usersHostsService, UsersHostsService.class);
        Long userId = getRequiredLongParam(req, PARAM_UID);
        List<ShortHostInfo> hostsVerifiedByUser = usersHostsService.getHostsVerifiedByUser(userId);
        res.addData(XmlConvertableCollectionWrapper.wrap(hostsVerifiedByUser, ShortHostInfoWrapper.class, TAG_HOSTLIST));
    }
}
